# SmartPawn Obfuscator
Version: 2.0

A proof-of-concept Obfuscator for traditional SourcePawn language (aka SourceMod 1.6).
While SmartPawn has been developed for the traditional SourcePawn language (aka SourceMod 1.6), obfuscated binaries still run on newer versions of SourceMod.

[Go here for the original SmartPawn Obfuscator repo.](https://github.com/Timocop/SmartPawn-Obfuscator)

[Download SourceMod 1.6 syntax files here.](https://github.com/Timocop/SmartPawn-Obfuscator/raw/master/sourcemod/sourcemod-1.6.4-git4625-windows.zip)
 
**Features:**
 + Renaming
 + Constant Disintegration
 + String Encoding
 + Type Obfuscation
 + Control Flow Obfuscation
 + Function Proxy Obfuscation
 + Decompiler Protection
 + Metadata Overflow
 + Server Whitelist
 + Shuffle Functions
 + Optimizations
 + Stack Trace decoder
 + Debug-Removal & Invalid-Debug (Modified SourcePawn Compiler 1.6.3)
 + Anti-Debugger

# Anti-Virus false positive detections
This is an Obfuscator and might be used for malicious purposes. 
Therefore, the SmartPawn binary could be marked as malicious even though it does no malicious acts. 
Add the SmartPawn binary to the Anti-Virus exclusion list if you want to use SmartPawn on your Computer. 
If you are still concerned, you can run SmartPawn in a Sandbox program (e.g. [Sandboxie](https://www.sandboxie.com/)) or Virtual Machine (e.g. [VirtualBox](https://www.virtualbox.org/), [VMware](https://www.vmware.com/)).

# License Violation Warning
Publishing obfuscated binaries or binaries without provided source code violates the SourceMod and GPL license!
Use at your own risk!

# Images
![](https://user-images.githubusercontent.com/22834512/118812731-b1b23a80-b8ae-11eb-9eba-53d0c25a9be2.png)
